#{{uc_id}} .stacked-image {
    position: relative;
    display: inline-block;
    text-decoration: none;
    line-height: 100%;
    transition: all 0.3s ease;
  	border-radius: 100%;
}

#{{uc_id}} .stacked-image img {
    display: flex;
    overflow: hidden;
    justify-content: center;
    background: #fff;
    transition: all 0.4s cubic-bezier(0.165, 0.84, 0.44, 1);
    object-fit: cover;
}

#{{uc_id}} .image-stack-container:hover .stacked-image {
    margin-left: 0;
}

#{{uc_id}} [tooltip] {
    position: relative;
}

#{{uc_id}} [tooltip]::after,
#{{uc_id}} [tooltip]::before {
    position: absolute;
    display: none;
    text-transform: none;
    line-height: 1;
    opacity: 0;
    pointer-events: none;
    user-select: none;
}

#{{uc_id}} [tooltip]:hover::after,
#{{uc_id}} [tooltip]:hover::before {
    display: block;
}

#{{uc_id}} [tooltip=""]::after,
#{{uc_id}} [tooltip=""]::before {
    display: none !important;
}

#{{uc_id}} [tooltip]::after,
#{{uc_id}} [tooltip]::before {
    left: 50%;
    transform: translate(-50%, -0.5em);
}

#{{uc_id}} [tooltip]:hover::after,
#{{uc_id}} [tooltip]:hover::before {
    animation: tooltip-animate 300ms ease-out forwards;
}

{% if tooltip_direction == "bottom" %}
	#{{uc_id}} [tooltip]::before {
      z-index: 1001;
      border: 5px solid transparent;
      content: "";
      top: 101%;
      border-top-width: 0;
	}

    #{{uc_id}} [tooltip]::after {
        z-index: 1000;
        overflow: hidden;
        min-width: 3em;
        max-width: 21em;
        box-shadow: 0 1em 2em -0.5em rgba(0, 0, 0, 0.35);
        content: attr(tooltip);
        text-align: center;
        text-overflow: ellipsis;
        white-space: nowrap;
        top: calc(100% + 5px);
    }
{% elseif tooltip_direction == "top" %}
	#{{uc_id}} [tooltip]::before {
        z-index: 1001;
        border: 5px solid transparent;
        content: "";
        bottom: 101%;
        border-bottom-width: 0;
    }

  #{{uc_id}} [tooltip]::after {
      z-index: 1000;
      overflow: hidden;
      min-width: 3em;
      max-width: 21em;
      box-shadow: 0 1em 2em -0.5em rgba(0, 0, 0, 0.35);
      content: attr(tooltip);
      text-align: center;
      text-overflow: ellipsis;
      white-space: nowrap;
      bottom: calc(100% + 5px);
  }
{% elseif tooltip_direction == "none" %}
	#{{uc_id}} [tooltip]::before, #{{uc_id}} [tooltip]::after {
      	display: none
	}
{% endif %}

#{{uc_id}}.uc-remote-parent .stacked-image{
  cursor:pointer;
}


@keyframes tooltip-animate {
    to {
        opacity: 0.9;
        transform: translate(-50%, 0);
    }
}