<?php
namespace Avayemarketing\AvaSMS\Elementor;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Avayemarketing\AvaSMS\Settings\Options;

if (!defined('ABSPATH')) exit;

class AvaSMS_Login_Register_Widget extends Widget_Base
{
    public function get_name() { return 'ava_sms_login_register'; }
    public function get_title() { return __('فرم ورود/ثبت‌نام پیامکی (AvaSMS)', 'avasms'); }
    public function get_icon() { return 'eicon-user-circle-o'; }
    public function get_categories() { return ['general']; }

    public function get_script_depends()
    {
        self::register_assets();
        return ['avasms-auth'];
    }

    public function get_style_depends()
    {
        self::register_assets();
        return ['avasms-auth'];
    }

    private static function register_assets(): void
    {
        if (!wp_script_is('avasms-auth', 'registered')) {
            wp_register_script(
                'avasms-auth',
                AVASMS_URL . 'assets/frontend/auth.js',
                ['jquery'],
                AVASMS_VERSION,
                true
            );
        }

        // Optional Cloudflare Turnstile
        if (!wp_script_is('avasms-turnstile', 'registered')) {
            wp_register_script(
                'avasms-turnstile',
                'https://challenges.cloudflare.com/turnstile/v0/api.js?render=explicit',
                [],
                null,
                true
            );
        }

        if (!wp_style_is('avasms-auth', 'registered')) {
            wp_register_style(
                'avasms-auth',
                AVASMS_URL . 'assets/frontend/auth.css',
                [],
                AVASMS_VERSION
            );
        }

    }

    protected function register_controls()
    {
        $this->start_controls_section('section_content', [
            'label' => __('تنظیمات فرم', 'avasms'),
        ]);

        $this->add_control('mode', [
            'label' => __('حالت نمایش', 'avasms'),
            'type' => Controls_Manager::SELECT,
            'default' => 'both',
            'options' => [
                'login' => __('فقط ورود', 'avasms'),
                'register' => __('فقط ثبت‌نام', 'avasms'),
                'both' => __('ورود + ثبت‌نام (تب)', 'avasms'),
            ],
        ]);

        
        $this->add_control('editor_preview', [
            'label' => __('پیش‌نمایش در ادیتور المنتور', 'avasms'),
            'type' => Controls_Manager::SELECT,
            'default' => 'form',
            'options' => [
                'form' => __('نمایش فرم (برای طراحی)', 'avasms'),
                'loggedin' => __('نمایش حالت «وارد شده‌اید»', 'avasms'),
            ],
            'description' => __('این گزینه فقط برای پیش‌نمایش در محیط ویرایش المنتور است.', 'avasms'),
        ]);
$this->add_control('default_tab', [
            'label' => __('تب پیش‌فرض', 'avasms'),
            'type' => Controls_Manager::SELECT,
            'default' => 'login',
            'options' => [
                'login' => __('ورود', 'avasms'),
                'register' => __('ثبت‌نام', 'avasms'),
            ],
            'condition' => ['mode' => 'both'],
        ]);

        $this->add_control('login_identifier_mode', [
            'label' => __('ورود با', 'avasms'),
            'type' => Controls_Manager::SELECT,
            'default' => 'auto',
            'options' => [
                'auto' => __('بر اساس تنظیمات افزونه (موبایل یا ایمیل)', 'avasms'),
                'mobile' => __('فقط موبایل', 'avasms'),
                'mobile_or_email' => __('موبایل یا ایمیل (قابل انتخاب)', 'avasms'),
            ],
            'condition' => ['mode!' => 'register'],
        ]);

        $this->add_control('captcha_mode', [
            'label' => __('کپچا', 'avasms'),
            'type' => Controls_Manager::SELECT,
            'default' => 'auto',
            'options' => [
                'auto' => __('بر اساس تنظیمات افزونه', 'avasms'),
                'off' => __('خاموش', 'avasms'),
                'turnstile' => __('Cloudflare Turnstile', 'avasms'),
            ],
        ]);

        $this->add_control('show_name_fields', [
            'label' => __('نمایش نام و نام خانوادگی (ثبت‌نام)', 'avasms'),
            'type' => Controls_Manager::SWITCHER,
            'default' => 'yes',
            'return_value' => 'yes',
        ]);

        $this->add_control('show_email_field', [
            'label' => __('نمایش فیلد ایمیل (ثبت‌نام)', 'avasms'),
            'type' => Controls_Manager::SWITCHER,
            'default' => 'no',
            'return_value' => 'yes',
        ]);

        $this->add_control('show_birthdate_field', [
            'label' => __('نمایش فیلد تاریخ تولد (ثبت‌نام)', 'avasms'),
            'type' => Controls_Manager::SWITCHER,
            'default' => 'yes',
            'return_value' => 'yes',
        ]);

        $this->add_control('show_marketing_optin', [
            'label' => __('نمایش گزینه دریافت پیامک تبلیغاتی', 'avasms'),
            'type' => Controls_Manager::SWITCHER,
            'default' => 'no',
            'return_value' => 'yes',
        ]);

        $this->add_control('otp_template', [
            'label' => __('متن پیامک OTP', 'avasms'),
            'type' => Controls_Manager::TEXTAREA,
            'default' => 'کد تایید شما: {code}',
            'description' => __('از {code} برای جایگذاری کد استفاده کنید.', 'avasms'),
        ]);

        $this->add_control('redirect_url', [
            'label' => __('آدرس ریدایرکت پس از موفقیت', 'avasms'),
            'type' => Controls_Manager::URL,
            'placeholder' => home_url('/'),
            'show_external' => false,
        ]);

        $this->add_control('login_title', [
            'label' => __('عنوان ورود', 'avasms'),
            'type' => Controls_Manager::TEXT,
            'default' => __('ورود با پیامک', 'avasms'),
        ]);

        $this->add_control('register_title', [
            'label' => __('عنوان ثبت‌نام', 'avasms'),
            'type' => Controls_Manager::TEXT,
            'default' => __('ثبت‌نام با پیامک', 'avasms'),
        ]);

        $this->add_control('btn_send_text', [
            'label' => __('متن دکمه ارسال کد', 'avasms'),
            'type' => Controls_Manager::TEXT,
            'default' => __('ارسال کد', 'avasms'),
        ]);

        $this->add_control('btn_verify_text', [
            'label' => __('متن دکمه تایید', 'avasms'),
            'type' => Controls_Manager::TEXT,
            'default' => __('تایید و ادامه', 'avasms'),
        ]);

        $this->end_controls_section();

        // Style: container
        $this->start_controls_section('section_style_container', [
            'label' => __('استایل: کانتینر', 'avasms'),
            'tab' => Controls_Manager::TAB_STYLE,
        ]);

        $this->add_responsive_control('container_padding', [
            'label' => __('Padding', 'avasms'),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%', 'em'],
            'selectors' => [
                '{{WRAPPER}} .avasms-auth' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        $this->add_control('container_bg', [
            'label' => __('پس‌زمینه', 'avasms'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .avasms-auth' => 'background-color: {{VALUE}};',
            ],
        ]);

        $this->add_group_control(Group_Control_Border::get_type(), [
            'name' => 'container_border',
            'selector' => '{{WRAPPER}} .avasms-auth',
        ]);

        $this->add_responsive_control('container_radius', [
            'label' => __('Border Radius', 'avasms'),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors' => [
                '{{WRAPPER}} .avasms-auth' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        $this->add_group_control(Group_Control_Box_Shadow::get_type(), [
            'name' => 'container_shadow',
            'selector' => '{{WRAPPER}} .avasms-auth',
        ]);

        $this->end_controls_section();

        // Style: labels & inputs
        $this->start_controls_section('section_style_fields', [
            'label' => __('استایل: فیلدها', 'avasms'),
            'tab' => Controls_Manager::TAB_STYLE,
        ]);

        $this->add_control('label_color', [
            'label' => __('رنگ لیبل', 'avasms'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .avasms-auth label' => 'color: {{VALUE}};',
            ],
        ]);

        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'label_typography',
            'selector' => '{{WRAPPER}} .avasms-auth label',
        ]);

        $this->add_control('input_color', [
            'label' => __('رنگ متن فیلد', 'avasms'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .avasms-auth input, {{WRAPPER}} .avasms-auth select' => 'color: {{VALUE}};',
            ],
        ]);

        $this->add_control('input_bg', [
            'label' => __('پس‌زمینه فیلد', 'avasms'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .avasms-auth input, {{WRAPPER}} .avasms-auth select' => 'background-color: {{VALUE}};',
            ],
        ]);

        $this->add_group_control(Group_Control_Border::get_type(), [
            'name' => 'input_border',
            'selector' => '{{WRAPPER}} .avasms-auth input, {{WRAPPER}} .avasms-auth select',
        ]);

        $this->add_responsive_control('input_radius', [
            'label' => __('Border Radius', 'avasms'),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors' => [
                '{{WRAPPER}} .avasms-auth input, {{WRAPPER}} .avasms-auth select' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        $this->add_responsive_control('input_padding', [
            'label' => __('Padding', 'avasms'),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em'],
            'selectors' => [
                '{{WRAPPER}} .avasms-auth input, {{WRAPPER}} .avasms-auth select' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        $this->end_controls_section();

        // Style: button
        $this->start_controls_section('section_style_button', [
            'label' => __('استایل: دکمه', 'avasms'),
            'tab' => Controls_Manager::TAB_STYLE,
        ]);

        $this->add_control('btn_color', [
            'label' => __('رنگ متن', 'avasms'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .avasms-auth .avasms-btn' => 'color: {{VALUE}};',
            ],
        ]);

        $this->add_control('btn_bg', [
            'label' => __('پس‌زمینه', 'avasms'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .avasms-auth .avasms-btn' => 'background-color: {{VALUE}};',
            ],
        ]);

        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'btn_typography',
            'selector' => '{{WRAPPER}} .avasms-auth .avasms-btn',
        ]);

        $this->add_group_control(Group_Control_Border::get_type(), [
            'name' => 'btn_border',
            'selector' => '{{WRAPPER}} .avasms-auth .avasms-btn',
        ]);

        $this->add_responsive_control('btn_radius', [
            'label' => __('Border Radius', 'avasms'),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors' => [
                '{{WRAPPER}} .avasms-auth .avasms-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        $this->add_responsive_control('btn_padding', [
            'label' => __('Padding', 'avasms'),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em'],
            'selectors' => [
                '{{WRAPPER}} .avasms-auth .avasms-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        $this->end_controls_section();
    }

    protected function render()
    {
        $s = $this->get_settings_for_display();

	            $is_editor = false;

        // Detect Elementor editor mode safely (works for Editor v2 too)
        if ( did_action('elementor/loaded') && class_exists('\Elementor\Plugin') ) {
            try {
                $is_editor = (bool) \Elementor\Plugin::$instance->editor->is_edit_mode();
            } catch (\Throwable $e) {
                $is_editor = false;
            }
        }


        // In Elementor editor: allow showing the form even when logged-in, to make design possible.
        if (is_user_logged_in() && !$is_editor) {
            echo '<div class="avasms-auth avasms-auth--loggedin">';
            echo '<div class="avasms-auth__notice">' . esc_html__('شما وارد شده‌اید.', 'avasms') . '</div>';
            echo '</div>';
            return;
        }

        if ($is_editor && (($s['editor_preview'] ?? 'form') === 'loggedin')) {
            echo '<div class="avasms-auth avasms-auth--loggedin">';
            echo '<div class="avasms-auth__notice">' . esc_html__('پیش‌نمایش: کاربر وارد شده است.', 'avasms') . '</div>';
            echo '</div>';
            return;
        }

        $mode = $s['mode'] ?? 'both';
        $default_tab = $s['default_tab'] ?? 'login';
        $redirect = !empty($s['redirect_url']['url']) ? esc_url($s['redirect_url']['url']) : home_url('/');

        $flags = [
            'show_name' => (($s['show_name_fields'] ?? '') === 'yes'),
            'show_email' => (($s['show_email_field'] ?? '') === 'yes'),
            'show_birthdate' => (($s['show_birthdate_field'] ?? '') === 'yes'),
            'show_optin' => (($s['show_marketing_optin'] ?? '') === 'yes'),
        ];

        $otp_opt = Options::otp();

        // Login identifier mode
        $login_identifier_mode = $s['login_identifier_mode'] ?? 'auto';
        $allow_email = !empty($otp_opt['allow_login_with_email']);
        if ($login_identifier_mode === 'mobile') $allow_email = false;
        if ($login_identifier_mode === 'mobile_or_email') $allow_email = true;

        // Captcha mode
        $captcha_mode = $s['captcha_mode'] ?? 'auto';
        $turnstile_enabled = !empty($otp_opt['turnstile_enabled']);
        $turnstile_site_key = (string)($otp_opt['turnstile_site_key'] ?? '');
        if ($captcha_mode === 'off') {
            $turnstile_enabled = false;
        } elseif ($captcha_mode === 'turnstile') {
            $turnstile_enabled = true;
        }

        if ($turnstile_enabled && $turnstile_site_key !== '') {
            wp_enqueue_script('avasms-turnstile');
        }

        $data = [
            'ajax_url' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('avasms_auth'),
            'template' => (string)($s['otp_template'] ?? 'کد تایید شما: {code}'),
            'redirect' => $redirect,
            'mode' => $mode,
            'allow_email' => $allow_email ? 1 : 0,
            'turnstile' => [
                'enabled' => ($turnstile_enabled && $turnstile_site_key !== '') ? 1 : 0,
                'site_key' => $turnstile_site_key,
            ],
        ];

        $wrapper_id = 'avasms-auth-' . $this->get_id();

        printf('<div id="%s" class="avasms-auth" data-avasms="%s">', esc_attr($wrapper_id), esc_attr(wp_json_encode($data)));

        if ($mode === 'both') {
            echo '<div class="avasms-tabs" role="tablist">';
            echo '<button type="button" class="avasms-tab' . ($default_tab==='login'?' is-active':'') . '" data-tab="login">' . esc_html($s['login_title'] ?? 'ورود با پیامک') . '</button>';
            echo '<button type="button" class="avasms-tab' . ($default_tab==='register'?' is-active':'') . '" data-tab="register">' . esc_html($s['register_title'] ?? 'ثبت‌نام با پیامک') . '</button>';
            echo '</div>';
        }

        // Login form
        if ($mode === 'login' || $mode === 'both') {
            echo '<div class="avasms-pane' . (($mode==='both' && $default_tab!=='login') ? '' : ' is-active') . '" data-pane="login">';
            echo '<div class="avasms-title">' . esc_html($s['login_title'] ?? 'ورود با پیامک') . '</div>';
            $this->render_form('login', $s, $flags, $allow_email, ($turnstile_enabled && $turnstile_site_key !== ''), $turnstile_site_key);
            echo '</div>';
        }

        // Register form
        if ($mode === 'register' || $mode === 'both') {
            echo '<div class="avasms-pane' . (($mode==='both' && $default_tab!=='register') ? '' : ' is-active') . '" data-pane="register">';
            echo '<div class="avasms-title">' . esc_html($s['register_title'] ?? 'ثبت‌نام با پیامک') . '</div>';
            $this->render_form('register', $s, $flags, $allow_email, ($turnstile_enabled && $turnstile_site_key !== ''), $turnstile_site_key);
            echo '</div>';
        }

        echo '</div>';
    }

    private function render_form(string $context, array $s, array $flags, bool $allow_email, bool $turnstile_enabled, string $turnstile_site_key): void
    {
        $btn_send = $s['btn_send_text'] ?? 'ارسال کد';
        $btn_verify = $s['btn_verify_text'] ?? 'تایید و ادامه';

        // Detect Elementor editor mode safely (avoid fatals when Elementor is not fully loaded).
        $is_editor = false;
        if (did_action('elementor/loaded') && class_exists('\\Elementor\\Plugin')) {
            $plugin = \Elementor\Plugin::$instance;
            if ($plugin && isset($plugin->editor) && is_object($plugin->editor) && method_exists($plugin->editor, 'is_edit_mode')) {
                $is_editor = (bool) $plugin->editor->is_edit_mode();
            }
        }


        $form_extra = $is_editor ? ' data-editor-preview="1"' : '';
        echo '<form class="avasms-form"' . $form_extra . ' data-context="' . esc_attr($context) . '" autocomplete="on">';
        if ($context === 'login' && $allow_email) {
            echo '<div class="avasms-row">';
            echo '<label>' . esc_html__('ورود با', 'avasms') . '</label>';
            echo '<select name="login_method" class="avasms-select">';
            echo '<option value="mobile">' . esc_html__('شماره موبایل', 'avasms') . '</option>';
            echo '<option value="email">' . esc_html__('ایمیل', 'avasms') . '</option>';
            echo '</select>';
            echo '</div>';

            echo '<div class="avasms-row">';
            echo '<label>' . esc_html__('شماره موبایل یا ایمیل', 'avasms') . '</label>';
            echo '<input type="text" name="identifier" autocomplete="username" placeholder="09xxxxxxxxx یا example@email.com" required>';
            echo '</div>';
        } else {
            echo '<div class="avasms-row">';
            echo '<label>' . esc_html__('شماره موبایل', 'avasms') . '</label>';
            echo '<input type="tel" name="mobile" inputmode="numeric" placeholder="09xxxxxxxxx" required>';
            echo '</div>';
        }

        if ($context === 'register' && !empty($flags['show_name'])) {
            echo '<div class="avasms-row">';
            echo '<label>' . esc_html__('نام', 'avasms') . '</label>';
            echo '<input type="text" name="first_name" autocomplete="given-name">';
            echo '</div>';

            echo '<div class="avasms-row">';
            echo '<label>' . esc_html__('نام خانوادگی', 'avasms') . '</label>';
            echo '<input type="text" name="last_name" autocomplete="family-name">';
            echo '</div>';
        }

        if ($context === 'register' && !empty($flags['show_email'])) {
            echo '<div class="avasms-row">';
            echo '<label>' . esc_html__('ایمیل', 'avasms') . '</label>';
            echo '<input type="email" name="email" autocomplete="email" placeholder="example@email.com">';
            echo '</div>';
        }

        if ($context === 'register' && !empty($flags['show_birthdate'])) {
            echo '<div class="avasms-row">';
            echo '<label>' . esc_html__('تاریخ تولد', 'avasms') . '</label>';
            echo '<input type="date" name="birthdate">';
            echo '</div>';
        }

        if ($context === 'register' && !empty($flags['show_optin'])) {
            echo '<div class="avasms-row avasms-row--checkbox">';
            echo '<label class="avasms-checkbox">';
            echo '<input type="checkbox" name="marketing_optin" value="1"> ';
            echo esc_html__('دریافت پیامک‌های اطلاع‌رسانی و پیشنهادها', 'avasms');
            echo '</label>';
            echo '</div>';
        }

        // Optional Turnstile captcha
        if ($turnstile_enabled && $turnstile_site_key !== '') {
            echo '<div class="avasms-row">';
            echo '<div class="avasms-turnstile" data-sitekey="' . esc_attr($turnstile_site_key) . '"></div>';
            echo '<input type="hidden" name="turnstile_token" value="">';
            echo '</div>';
        }

        echo '<div class="avasms-row avasms-row--actions">';
        echo '<button type="button" class="avasms-btn avasms-btn--send" data-action="send">' . esc_html($btn_send) . '</button>';
        echo '</div>';

        echo '<div class="avasms-otp" style="display:none;">';
        echo '<div class="avasms-row">';
        echo '<label>' . esc_html__('کد تایید', 'avasms') . '</label>';
        echo '<input type="text" name="code" inputmode="numeric" maxlength="6" placeholder="******">';
        echo '</div>';
        echo '<div class="avasms-row avasms-row--actions">';
        echo '<button type="button" class="avasms-btn avasms-btn--verify" data-action="verify">' . esc_html($btn_verify) . '</button>';
        echo '<button type="button" class="avasms-link" data-action="resend">' . esc_html__('ارسال مجدد', 'avasms') . '</button>';
        echo '</div>';
        echo '</div>';

        echo '<div class="avasms-msg" aria-live="polite"></div>';
        echo '</form>';
    }
}