<?php
namespace Avayemarketing\AvaSMS\SMS;

use Avayemarketing\AvaSMS\SMS\Gateways\IppanelGateway;
use Avayemarketing\AvaSMS\SMS\Gateways\KavenegarGateway;
use Avayemarketing\AvaSMS\SMS\Gateways\FarazSmsGateway;
use Avayemarketing\AvaSMS\SMS\Gateways\MelliSmsGateway;

if (!defined('ABSPATH')) exit;

final class GatewayFactory
{
    /**
     * @param string $active_gateway
     * @param array $settings Settings array for all gateways
     */
    public static function make(string $active_gateway, array $settings): GatewayInterface
    {
        $active_gateway = sanitize_key($active_gateway);

        switch ($active_gateway) {
            case 'ippanel':
                return new IppanelGateway($settings['ippanel'] ?? []);
            case 'farazsms':
                return new FarazSmsGateway($settings['farazsms'] ?? []);
            case 'melli_sms':
            case 'melipayamak':
                return new MelliSmsGateway($settings['melli_sms'] ?? ($settings['melipayamak'] ?? []));
            case 'kavenegar':
            default:
                return new KavenegarGateway($settings['kavenegar'] ?? []);
        }
    }
}
