<?php
namespace Avayemarketing\AvaSMS\SMS;

if (!defined('ABSPATH')) exit;

interface GatewayInterface
{
    /**
     * Send SMS via provider.
     *
     * @param string $to E164 or local mobile (09xxxxxxxxx / 98xxxxxxxxxx / +98xxxxxxxxxx).
     * @param string $message SMS message body.
     * @param array $args Optional provider args (template, sender, etc).
     *
     * @return array {
     *   @type bool        $success
     *   @type string      $message Human readable result
     *   @type mixed       $provider_response Raw provider response (array|string|null)
     *   @type string|null $error_code Provider error code if any
     * }
     */
    public function send(string $to, string $message, array $args = []): array;

    /**
     * Provider identifier key (e.g. kavenegar, ippanel).
     */
    public function key(): string;

    /**
     * Validate settings for gateway.
     */
    public function is_configured(): bool;
}
