<?php
namespace Avayemarketing\AvaSMS\SMS;

if (!defined('ABSPATH')) exit;

final class Utils
{
    /**
     * Normalize Iranian mobile numbers to 09xxxxxxxxx
     */
    public static function normalize_iran_mobile(string $mobile): string
    {
        $m = preg_replace('/\D+/', '', $mobile);
        if ($m === null) $m = '';
        $m = (string)$m;

        if ($m === '') return '';

        // +98 or 98
        if (strpos($m, '98') === 0 && strlen($m) === 12) {
            $m = '0' . substr($m, 2);
        }

        // 9xxxxxxxxx
        if (strpos($m, '9') === 0 && strlen($m) === 10) {
            $m = '0' . $m;
        }

        if (strpos($m, '09') === 0 && strlen($m) === 11) return $m;

        return '';
    }
}
