<?php
namespace AvayeMarketing\AvaSlider;

use Elementor\Plugin as ElementorPlugin;

if ( ! defined( 'ABSPATH' ) ) exit;

class Plugin {

    private static $instance = null;

    public static function instance() {
        if ( self::$instance === null ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        add_action( 'elementor/widgets/register', [ $this, 'register_widgets' ] );
        add_action( 'wp_enqueue_scripts', [ $this, 'register_assets' ] );
    }

    public function register_assets() {
        wp_register_style( 'avaslider-css', plugins_url( '../assets/css/avaslider.css', __FILE__ ) );
        wp_register_script( 'avaslider-js', plugins_url( '../assets/js/avaslider.js', __FILE__ ), ['jquery'], '1.0', true );
    }

    public function register_widgets( $widgets_manager ) {
        require_once __DIR__ . '/../widgets/CircularSlider.php';
        $widgets_manager->register( new \AvayeMarketing\AvaSlider\Widgets\CircularSlider() );
    }
}
