<?php
/**
 * Plugin Name: Ava Marketing Core (Services + Portfolio)
 * Description: Custom post types (Services, Portfolio), taxonomies, term meta, post meta, and Elementor Pro Dynamic Tags.
 * Version: 1.0.2
 * Author: Avaye Marketing
 * Text Domain: ava-marketing-core
 */

defined('ABSPATH') || exit;

define('AVA_MC_PATH', plugin_dir_path(__FILE__));
define('AVA_MC_URL',  plugin_dir_url(__FILE__));

require_once AVA_MC_PATH . 'includes/cpt-services.php';
require_once AVA_MC_PATH . 'includes/cpt-portfolio.php';
require_once AVA_MC_PATH . 'includes/term-meta.php';
require_once AVA_MC_PATH . 'includes/admin-media.php';
require_once AVA_MC_PATH . 'includes/post-meta.php';
require_once AVA_MC_PATH . 'includes/elementor-dynamic.php';

register_activation_hook(__FILE__, function () {
    require_once AVA_MC_PATH . 'includes/cpt-services.php';
    require_once AVA_MC_PATH . 'includes/cpt-portfolio.php';
    flush_rewrite_rules();
});

register_deactivation_hook(__FILE__, function () {
    flush_rewrite_rules();
});
