<?php
defined('ABSPATH') || exit;

add_action('init', function () {

    $labels = [
        'name'               => 'نمونه‌کارها',
        'singular_name'      => 'نمونه‌کار',
        'menu_name'          => 'نمونه‌کارها',
        'name_admin_bar'     => 'نمونه‌کار',
        'add_new'            => 'افزودن',
        'add_new_item'       => 'افزودن نمونه‌کار جدید',
        'new_item'           => 'نمونه‌کار جدید',
        'edit_item'          => 'ویرایش نمونه‌کار',
        'view_item'          => 'مشاهده نمونه‌کار',
        'all_items'          => 'همه نمونه‌کارها',
        'search_items'       => 'جستجوی نمونه‌کارها',
        'not_found'          => 'موردی یافت نشد.',
        'not_found_in_trash' => 'موردی در زباله‌دان یافت نشد.',
    ];

    register_post_type('portfolio', [
        'labels'             => $labels,
        'public'             => true,
        'has_archive'        => true,
        'rewrite'            => ['slug' => 'portfolio', 'with_front' => false],
        'menu_position'      => 21,
        'menu_icon'          => 'dashicons-portfolio',
        'supports'           => ['title', 'editor', 'thumbnail', 'excerpt', 'revisions'],
        'show_in_rest'       => true,
        'hierarchical'       => false,
        'publicly_queryable' => true,
        'exclude_from_search'=> false,
    ]);

    $tax_labels = [
        'name'              => 'دسته‌بندی نمونه‌کار',
        'singular_name'     => 'دسته نمونه‌کار',
        'search_items'      => 'جستجوی دسته‌ها',
        'all_items'         => 'همه دسته‌ها',
        'parent_item'       => 'دسته مادر',
        'parent_item_colon' => 'دسته مادر:',
        'edit_item'         => 'ویرایش دسته',
        'update_item'       => 'به‌روزرسانی دسته',
        'add_new_item'      => 'افزودن دسته جدید',
        'new_item_name'     => 'نام دسته جدید',
        'menu_name'         => 'دسته‌بندی نمونه‌کار',
    ];

    register_taxonomy('portfolio_category', ['portfolio'], [
        'labels'            => $tax_labels,
        'public'            => true,
        'hierarchical'      => true,
        'show_admin_column' => true,
        'show_in_rest'      => true,
        'rewrite'           => ['slug' => 'portfolio-category', 'with_front' => false],
    ]);

}, 0);
