<?php
defined('ABSPATH') || exit;

class Ava_MC_Post_Meta {

    private static array $post_types = ['services', 'portfolio'];

    public static function init(): void {
        add_action('add_meta_boxes', [__CLASS__, 'register_metaboxes']);
        add_action('save_post', [__CLASS__, 'save_metaboxes']);
    }

    public static function register_metaboxes(): void {
        foreach (self::$post_types as $pt) {
            add_meta_box(
                'ava_mc_details',
                'جزئیات',
                [__CLASS__, 'render_metabox'],
                $pt,
                'normal',
                'default'
            );
        }
    }

    public static function render_metabox(\WP_Post $post): void {
        wp_nonce_field('ava_mc_save_post_meta', 'ava_mc_post_meta_nonce');

        $subtitle  = get_post_meta($post->ID, 'ava_subtitle', true);
        $cta_label = get_post_meta($post->ID, 'ava_cta_label', true);
        $cta_url   = get_post_meta($post->ID, 'ava_cta_url', true);

        $faq_q1 = get_post_meta($post->ID, 'ava_faq_q1', true);
        $faq_a1 = get_post_meta($post->ID, 'ava_faq_a1', true);
        $faq_q2 = get_post_meta($post->ID, 'ava_faq_q2', true);
        $faq_a2 = get_post_meta($post->ID, 'ava_faq_a2', true);
        $faq_q3 = get_post_meta($post->ID, 'ava_faq_q3', true);
        $faq_a3 = get_post_meta($post->ID, 'ava_faq_a3', true);

        $price_from = get_post_meta($post->ID, 'ava_price_from', true);
        $delivery_time = get_post_meta($post->ID, 'ava_delivery_time', true);

        $client_name = get_post_meta($post->ID, 'ava_client_name', true);
        $project_url = get_post_meta($post->ID, 'ava_project_url', true);
        $industry    = get_post_meta($post->ID, 'ava_industry', true);

        ?>
        <p>
            <label for="ava_subtitle"><strong>زیرعنوان (اختیاری)</strong></label><br>
            <input type="text" id="ava_subtitle" name="ava_subtitle" value="<?php echo esc_attr($subtitle); ?>" class="widefat">
        </p>

        <p>
            <label for="ava_cta_label"><strong>متن دکمه CTA (اختیاری)</strong></label><br>
            <input type="text" id="ava_cta_label" name="ava_cta_label" value="<?php echo esc_attr($cta_label); ?>" class="widefat">
        </p>

        <p>
            <label for="ava_cta_url"><strong>لینک CTA (اختیاری)</strong></label><br>
            <input type="url" id="ava_cta_url" name="ava_cta_url" value="<?php echo esc_attr($cta_url); ?>" class="widefat">
        </p>

        <?php if (get_post_type($post) === 'services'): ?>
            <hr>
            <p><strong>اطلاعات خدمت (اختیاری)</strong></p>

            <p>
                <label for="ava_price_from">شروع قیمت</label><br>
                <input type="text" id="ava_price_from" name="ava_price_from" value="<?php echo esc_attr($price_from); ?>" class="widefat">
            </p>

            <p>
                <label for="ava_delivery_time">زمان تحویل</label><br>
                <input type="text" id="ava_delivery_time" name="ava_delivery_time" value="<?php echo esc_attr($delivery_time); ?>" class="widefat">
            </p>

            <hr>
            <p><strong>سوالات متداول (اختیاری)</strong></p>

            <p>
                <label>سوال ۱</label>
                <input type="text" name="ava_faq_q1" value="<?php echo esc_attr($faq_q1); ?>" class="widefat">
                <label>پاسخ ۱</label>
                <textarea name="ava_faq_a1" class="widefat" rows="3"><?php echo esc_textarea($faq_a1); ?></textarea>
            </p>

            <p>
                <label>سوال ۲</label>
                <input type="text" name="ava_faq_q2" value="<?php echo esc_attr($faq_q2); ?>" class="widefat">
                <label>پاسخ ۲</label>
                <textarea name="ava_faq_a2" class="widefat" rows="3"><?php echo esc_textarea($faq_a2); ?></textarea>
            </p>

            <p>
                <label>سوال ۳</label>
                <input type="text" name="ava_faq_q3" value="<?php echo esc_attr($faq_q3); ?>" class="widefat">
                <label>پاسخ ۳</label>
                <textarea name="ava_faq_a3" class="widefat" rows="3"><?php echo esc_textarea($faq_a3); ?></textarea>
            </p>
        <?php else: ?>
            <hr>
            <p><strong>اطلاعات نمونه‌کار (اختیاری)</strong></p>

            <p>
                <label for="ava_client_name">نام مشتری</label><br>
                <input type="text" id="ava_client_name" name="ava_client_name" value="<?php echo esc_attr($client_name); ?>" class="widefat">
            </p>

            <p>
                <label for="ava_project_url">لینک پروژه</label><br>
                <input type="url" id="ava_project_url" name="ava_project_url" value="<?php echo esc_attr($project_url); ?>" class="widefat">
            </p>

            <p>
                <label for="ava_industry">صنعت</label><br>
                <input type="text" id="ava_industry" name="ava_industry" value="<?php echo esc_attr($industry); ?>" class="widefat">
            </p>
        <?php endif; ?>
        <?php
    }

    public static function save_metaboxes(int $post_id): void {
        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

        if (!isset($_POST['ava_mc_post_meta_nonce']) || !wp_verify_nonce($_POST['ava_mc_post_meta_nonce'], 'ava_mc_save_post_meta')) {
            return;
        }

        $post_type = get_post_type($post_id);
        if (!in_array($post_type, self::$post_types, true)) return;

        if (!current_user_can('edit_post', $post_id)) return;

        $fields_text = [
            'ava_subtitle',
            'ava_cta_label',
            'ava_price_from',
            'ava_delivery_time',
            'ava_client_name',
            'ava_industry',
            'ava_faq_q1','ava_faq_q2','ava_faq_q3',
        ];

        foreach ($fields_text as $k) {
            $val = isset($_POST[$k]) ? sanitize_text_field(wp_unslash($_POST[$k])) : '';
            update_post_meta($post_id, $k, $val);
        }

        $fields_textarea = ['ava_faq_a1','ava_faq_a2','ava_faq_a3'];
        foreach ($fields_textarea as $k) {
            $val = isset($_POST[$k]) ? sanitize_textarea_field(wp_unslash($_POST[$k])) : '';
            update_post_meta($post_id, $k, $val);
        }

        $url_fields = ['ava_cta_url','ava_project_url'];
        foreach ($url_fields as $k) {
            $val = isset($_POST[$k]) ? esc_url_raw(wp_unslash($_POST[$k])) : '';
            update_post_meta($post_id, $k, $val);
        }
    }
}

Ava_MC_Post_Meta::init();
