<?php
defined('ABSPATH') || exit;

class Ava_MC_Term_Meta {

    private static array $taxonomies = [
        'category',
        'service_category',
        'portfolio_category',
    ];

    public static function init(): void {
        foreach (self::$taxonomies as $tax) {
            add_action("{$tax}_add_form_fields",  [__CLASS__, 'render_add_fields'],  10, 1);
            add_action("{$tax}_edit_form_fields", [__CLASS__, 'render_edit_fields'], 10, 2);

            add_action("created_{$tax}", [__CLASS__, 'save_term_meta'], 10, 2);
            add_action("edited_{$tax}",  [__CLASS__, 'save_term_meta'], 10, 2);
        }
    }

    public static function render_add_fields(string $taxonomy): void {
        wp_nonce_field('ava_mc_term_meta_save', 'ava_mc_term_meta_nonce');
        ?>
        <div class="form-field">
            <label for="ava_en_title">عنوان انگلیسی</label>
            <input type="text" name="ava_en_title" id="ava_en_title" placeholder="web-design">
        </div>

        <div class="form-field">
            <label for="ava_marketing_title">عنوان تبلیغاتی</label>
            <input type="text" name="ava_marketing_title" id="ava_marketing_title" placeholder="مثال: طراحی سایت حرفه‌ای برای رشد فروش">
        </div>

        <div class="form-field">
            <label>تصویر و آیکون</label>

            <div class="ava-mc-two-col">
                <div class="ava-mc-col ava-mc-image-field">
                    <strong style="display:block;margin-bottom:6px;">تصویر شاخص</strong>
                    <input type="hidden" name="ava_image_id" class="ava-mc-image-id" value="">
                    <button type="button" class="button ava-mc-upload">انتخاب تصویر</button>
                    <button type="button" class="button ava-mc-remove" style="display:none;">حذف</button>
                    <div class="ava-mc-preview" style="margin-top:10px;"></div>
                </div>

                <div class="ava-mc-col ava-mc-icon-field">
                    <strong style="display:block;margin-bottom:6px;">آیکون</strong>
                    <input type="hidden" name="ava_icon_image_id" class="ava-mc-icon-id" value="">
                    <button type="button" class="button ava-mc-icon-upload">انتخاب آیکون</button>
                    <button type="button" class="button ava-mc-icon-remove" style="display:none;">حذف</button>
                    <div class="ava-mc-icon-preview" style="margin-top:10px;"></div>
                </div>
            </div>
        </div>
        <?php
    }

    public static function render_edit_fields(\WP_Term $term, string $taxonomy): void {
        $en_title        = get_term_meta($term->term_id, 'ava_en_title', true);
        $marketing_title = get_term_meta($term->term_id, 'ava_marketing_title', true);

        $image_id  = (int) get_term_meta($term->term_id, 'ava_image_id', true);
        $image_url = $image_id ? wp_get_attachment_image_url($image_id, 'medium') : '';

        $icon_id  = (int) get_term_meta($term->term_id, 'ava_icon_image_id', true);
        $icon_url = $icon_id ? wp_get_attachment_image_url($icon_id, 'thumbnail') : '';

        wp_nonce_field('ava_mc_term_meta_save', 'ava_mc_term_meta_nonce');
        ?>
        <tr class="form-field">
            <th scope="row"><label for="ava_en_title">عنوان انگلیسی</label></th>
            <td><input type="text" name="ava_en_title" id="ava_en_title" value="<?php echo esc_attr($en_title); ?>" class="regular-text"></td>
        </tr>

        <tr class="form-field">
            <th scope="row"><label for="ava_marketing_title">عنوان تبلیغاتی</label></th>
            <td><input type="text" name="ava_marketing_title" id="ava_marketing_title" value="<?php echo esc_attr($marketing_title); ?>" class="regular-text"></td>
        </tr>

        <tr class="form-field">
            <th scope="row"><label>تصویر و آیکون</label></th>
            <td>
                <div class="ava-mc-two-col">
                    <div class="ava-mc-col ava-mc-image-field">
                        <strong style="display:block;margin-bottom:6px;">تصویر شاخص</strong>
                        <input type="hidden" name="ava_image_id" class="ava-mc-image-id" value="<?php echo esc_attr($image_id); ?>">
                        <button type="button" class="button ava-mc-upload">انتخاب تصویر</button>
                        <button type="button" class="button ava-mc-remove" <?php echo $image_id ? '' : 'style="display:none;"'; ?>>حذف</button>
                        <div class="ava-mc-preview" style="margin-top:10px;">
                            <?php if ($image_url): ?>
                                <img src="<?php echo esc_url($image_url); ?>" style="max-width:220px;height:auto;border:1px solid #ddd;padding:4px;background:#fff;">
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="ava-mc-col ava-mc-icon-field">
                        <strong style="display:block;margin-bottom:6px;">آیکون</strong>
                        <input type="hidden" name="ava_icon_image_id" class="ava-mc-icon-id" value="<?php echo esc_attr($icon_id); ?>">
                        <button type="button" class="button ava-mc-icon-upload">انتخاب آیکون</button>
                        <button type="button" class="button ava-mc-icon-remove" <?php echo $icon_id ? '' : 'style="display:none;"'; ?>>حذف</button>
                        <div class="ava-mc-icon-preview" style="margin-top:10px;">
                            <?php if ($icon_url): ?>
                                <img src="<?php echo esc_url($icon_url); ?>" style="max-width:90px;height:auto;border:1px solid #ddd;padding:4px;background:#fff;">
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </td>
        </tr>
        <?php
    }

    public static function save_term_meta(int $term_id, int $tt_id): void {
        if (!isset($_POST['ava_mc_term_meta_nonce']) || !wp_verify_nonce($_POST['ava_mc_term_meta_nonce'], 'ava_mc_term_meta_save')) {
            return;
        }

        if (!current_user_can('manage_categories')) {
            return;
        }

        $en_title        = isset($_POST['ava_en_title']) ? sanitize_text_field(wp_unslash($_POST['ava_en_title'])) : '';
        $marketing_title = isset($_POST['ava_marketing_title']) ? sanitize_text_field(wp_unslash($_POST['ava_marketing_title'])) : '';
        $image_id        = isset($_POST['ava_image_id']) ? absint($_POST['ava_image_id']) : 0;
        $icon_image_id   = isset($_POST['ava_icon_image_id']) ? absint($_POST['ava_icon_image_id']) : 0;

        update_term_meta($term_id, 'ava_en_title', $en_title);
        update_term_meta($term_id, 'ava_marketing_title', $marketing_title);
        update_term_meta($term_id, 'ava_image_id', $image_id);
        update_term_meta($term_id, 'ava_icon_image_id', $icon_image_id);
    }
}

Ava_MC_Term_Meta::init();
