<?php
defined('ABSPATH') || exit;
get_header();
?>
<main id="primary" class="site-main container">
    <header class="page-header">
        <h1 class="page-title"><?php the_archive_title(); ?></h1>
        <?php the_archive_description('<div class="archive-description">', '</div>'); ?>
    </header>

    <?php if ( have_posts() ) : ?>
        <?php while ( have_posts() ) : the_post(); ?>
            <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                <header class="entry-header">
                    <h2 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                    <div class="entry-meta">
                        <?php if (function_exists('businesspro_the_date')) { businesspro_the_date('Y/m/d'); } else { echo esc_html(get_the_date()); } ?>
                    </div>
                </header>
                <div class="entry-content">
                    <?php the_excerpt(); ?>
                </div>
            </article>
        <?php endwhile; ?>

        <nav class="navigation pagination">
            <?php the_posts_pagination(); ?>
        </nav>
    <?php else : ?>
        <p><?php esc_html_e('Nothing found.', 'businesspro'); ?></p>
    <?php endif; ?>
</main>
<?php get_footer(); ?>
