<?php
defined('ABSPATH') || exit;

function businesspro_schema_markup() {

    // Avoid conflicts with SEO plugins that already output Organization schema.
    if (defined('RANK_MATH_VERSION') || defined('WPSEO_VERSION')) {
        return;
    }

    $logo = '';
    $custom_logo_id = (int) get_theme_mod('custom_logo');
    if ($custom_logo_id) {
        $logo = wp_get_attachment_image_url($custom_logo_id, 'full');
    }

    $schema = [
        '@context' => 'https://schema.org',
        '@type'    => 'Organization',
        'name'     => get_bloginfo('name'),
        'url'      => home_url('/'),
    ];

    if ($logo) {
        $schema['logo'] = $logo;
    }

    echo '<script type="application/ld+json">' . wp_json_encode($schema) . '</script>';
}
