jQuery(document).ready(function(){

const resolver = {
  resolve: function resolve(options, callback) {
    // The string to resolve
    const resolveString = options.resolveString || options.element.getAttribute('data-target-resolver');
    const combinedOptions = Object.assign({}, options, { resolveString: resolveString });

    function getRandomInteger(min, max) {
      return Math.floor(Math.random() * (max - min + 1)) + min;
    };

    function randomCharacter(characters) {
      return characters[getRandomInteger(0, characters.length - 1)];
    };

    function doRandomiserEffect(options, callback) {
      const characters = options.characters;
      const timeout = options.timeout;
      const element = options.element;
      const partialString = options.partialString;

      let iterations = options.iterations;

      setTimeout(() => {
        if (iterations >= 0) {
          const nextOptions = Object.assign({}, options, { iterations: iterations - 1 });

          // Ensures partialString without the random character as the final state.
          if (iterations === 0) {
            element.textContent = partialString;
          } else {
            // Replaces the last character of partialString with a random character
            element.textContent = partialString.substring(0, partialString.length - 1) + randomCharacter(characters);
          }

          doRandomiserEffect(nextOptions, callback);
        } else if (typeof callback === "function") {
          callback();
        }
      }, options.timeout);
    };

    function doResolverEffect(options, callback) {
      const resolveString = options.resolveString;
      const characters = options.characters;
      const offset = options.offset;
      const partialString = resolveString.substring(0, offset);
      const combinedOptions = Object.assign({}, options, { partialString: partialString });

      doRandomiserEffect(combinedOptions, () => {
        const nextOptions = Object.assign({}, options, { offset: offset + 1 });

        if (offset <= resolveString.length) {
          doResolverEffect(nextOptions, callback);
        } else if (typeof callback === "function") {
          callback();
        }
      });
    };


    doResolverEffect(combinedOptions, callback);
  }

};
const strings = [
  
  
{{put_items()}}
 
  
];


let counter = 0;

const options = {
  // Initial position
  offset: 0,
  // Timeout between each random character
  timeout: {{timeout_between_each_character}},
  // Number of random characters to show
  iterations: 10,
  // Random characters to pick from
  characters: ['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'x', 'y', 'x', '#', '%', '&', '-', '+', '_', '?', '/', '\\', '='],
  // String to resolve
  resolveString: strings[counter],
  // The element
  element: document.getElementById("{{uc_id}}")


  // Callback function when resolve completes
};function callback() {
  setTimeout(() => {
    counter++;

	if (counter >= strings.length) {
	  counter = 0;
      {%if is_loop == "false" %}
      return(false);
      {%endif%}
	}

    let nextOptions = Object.assign({}, options, { resolveString: strings[counter] });
    resolver.resolve(nextOptions, callback);
  }, {{transition_delay}});
}

{% if trigger_effect_when_in_viewport == "true" %}    
  function startTypingEffect(entries, observer) {
    entries.forEach(entry => {
      if (entry.isIntersecting) {
        setTimeout(() => {
          
          // Start the typing effect when the observed element is in view
          resolver.resolve(options, callback);
          
          // Stop observing once the typing effect has started
          observer.unobserve(entry.target);
        }, {{trigger_delay}});
      }
    });
  }
  const observerOptions = {
    root: null,
    threshold: 0.5,
  };

  // The element to observe
  const observedElement = document.getElementById("{{uc_id}}");

  // Create a new Intersection Observer
  const observer = new IntersectionObserver(startTypingEffect, observerOptions);

  // Start observing the element
  observer.observe(observedElement);
 
{% else %}

  resolver.resolve(options, callback);
 
{% endif %}
    
});