#{{uc_id}} *{
  box-sizing:border-box;
}

#{{uc_id}}{
  display: grid;
  grid-auto-rows: 1fr;
}

#{{uc_id}} div.ue-grid-item{
  overflow:hidden;
  display:flex;
  position:relative;
}

#{{uc_id}} .ue-grid-item-intro{
  position: relative;
  z-index: 1;
}

#{{uc_id}} .ue-grid-item-image img{
  width:100%;
  display:block;
}

#{{uc_id}}.ue-layout-cover .ue-grid-item-image{
  position:absolute;
  top:0;
  left:0;
  bottom:0;
  right:0;
}

#{{uc_id}}.ue-layout-cover .ue-grid-item-image img{
  height:100%;
  object-fit: cover;
}

#{{uc_id}}.ue-layout-cover .ue-grid-item-content{
  position:absolute;
  width:100%;
  bottom:0px;
}

#{{uc_id}} .ue-grid-item-image-overlay{
  position:absolute;
  z-index: 1;
  width:100%;
  top:0;
  display:block;
  bottom:0;
  height:100%;
  transition:0.3s;
}

.ue-grid-item-title a{
  font-size:21px;
  font-weight:bold;
  position: relative;
  z-index: 1;  
}

.ue-grid-item-category a{
  display:inline-block;
  font-size:10px;
  text-transform:uppercase;
  position: relative;
  z-index: 1; 
}

#{{uc_id}} .uc_more_btn{
  text-align:center;
  text-decoration:none;
  transition:0.3s;
  position: relative;
  z-index: 1;
}

#{{uc_id}} .ue-grid-item-meta-data{
  display:flex;
  flex-wrap: wrap;
}

.ue-grid-item-meta-data{
  font-size:12px;
}

#{{uc_id}} .ue-grid-item-meta-data-icon{
  line-height:1em;
}

#{{uc_id}} .ue-grid-item-meta-data-icon svg{
  width:1em;
  height:1em;
}

{% if category_position == "absolute" %}
	#{{uc_id}} .ue-grid-item-category    {
      position:absolute;
      {{cat_vertical_snap}}:{{cat_vertical_distance}}px;
     {{cat_horizontal_snap}}:{{cat_horizontal_distance}}px;
      line-height:1em;
    }
{% endif %}


#{{uc_id}} .ue-date-calendar{
     position:absolute;
     {{calendar_vertical_snap}}:{{calendar_vertical_distance}}px;
     {{calendar_horizontal_snap}}:{{calendar_horizontal_distance}}px;
     text-align:center;
}

@media only screen and (max-width: {{responsive_breakpoint}}px) {
  #{{uc_id}} div.ue-grid-item  {
    grid-column: span 1;
    grid-row: span 1;
  }
  
  #{{uc_id}}  {
  grid-template-columns: repeat({{responsive_number_of_columns}}, 1fr);
  }
}

{% if show_badge_ribbon == "true" %}
  
#{{uc_id}} .ue-badge-ribbon{
  position:absolute;
  z-index:1;
}

{% endif %}