
function UCDynamicAccordion(objAccordion){
  
  var g_activeClass;
  var g_scrollOffset;
  
  //scroll func
  function scrollToTop(){
    var panel = jQuery(this).closest(".uc_ac_box");
    
    jQuery('html, body').animate({
      scrollTop: panel.offset().top + g_scrollOffset
    }, 400);
  }
   
  /**
  * set hash
  */
   function setHash(objTab){
    
    var isHashSet = objAccordion.data("set-hash");
    
    if(isHashSet == false)
    return(false);
    
    var objTabDataId = objTab.parent().attr('id');
    
    window.location.hash = objTabDataId;    
    
  }
  
  function onItemClick(){
    
    var objCaption = jQuery(this);
    var objContent = objCaption.next();
    var objItem = objCaption.parent();

    setHash(objCaption);
    
    var isActive = objCaption.hasClass(g_activeClass);
    
    if(isActive == true){              
      objCaption.removeClass(g_activeClass);
      objContent.slideUp();        	            	
      return(true);
    }

    var objItems = objItem.siblings();

    objItems.each(function(){

      var objTab = jQuery(this);
      var isTabActive = objTab.children().hasClass(g_activeClass);
   
      //remove active class from all other tabs
      //use carefully, not to touch inner accordion if such exists
      if(isTabActive == true){
        objTab.children().removeClass(g_activeClass);
        objTab.removeClass(g_activeClass);
        objTab.find(" > .ue_accordion_content").slideUp();        
      }

    }); 
    
    objCaption.addClass(g_activeClass);
    objItem.addClass(g_activeClass);
    
    var dataScroll = objAccordion.data('scroll');
    
    if (dataScroll == "desktop"){
      if(window.matchMedia("(min-width: 1024px)").matches){
        objContent.slideDown(scrollToTop);
      }else{
        objContent.slideDown();
      }
    }
    
    if (dataScroll == "mobile"){
      if(window.matchMedia("(max-width: 1024px)").matches){
        objContent.slideDown(scrollToTop);
      }else{
        objContent.slideDown();
      }
    }
    
    if (dataScroll == "desktop+mobile"){
      objContent.slideDown(scrollToTop);
    }
    
    if (dataScroll == "off"){
      objContent.slideDown();
    }
    
    return false;
  }
  
  function openFirstItem(){
    
    var openFirst = objAccordion.data('first-opened');
    
    if(openFirst == false)
    return(false);
    
    var firstItem = objAccordion.find(".ue-accordion-item").eq(0);
    firstItem.addClass('active');
    firstItem.children().addClass('active').next().show();
    
  }

  function runPostAccordion(){
    
    //init globals    
    g_activeClass = "active";    
    g_scrollOffset = objAccordion.data('offset');
    
    openFirstItem();
    
    //init events
    
    objAccordion.on("click", ".uc_trigger", onItemClick);
    objAccordion.on("ucclick", ".uc_trigger", onItemClick);
    objAccordion.on("uc_ajax_refreshed", openFirstItem);
     
    //init hash
    if(!window.location.hash)
    return(false);
        
    //find hashed tab object
    var objHashedTabs = jQuery('[id=' + window.location.hash + ']');

    objHashedTabs.each(function(){

      var objHashedTab = jQuery(this);

      //find main widget wrapper of the hashed tab
      var objHashedTabWrapper = objHashedTab.parents('.uc_material_accordion'); 

      //find if main widget wrapper is inside another accordion tab
      var objWrapperParent = objHashedTabWrapper.parents('.uc-items-wrapper');

      //if not than trigger click on hashed tab only and move to another hashed tab object
      //do nothing with inner accordion on this stage (if its exists)
      if(!objWrapperParent.length){
          
        setTimeout(function(){

          //find if tab is active
          var isActive = objHashedTab.hasClass(g_activeClass);

          if(isActive == true)
          return(true);

          objHashedTab.find(' > .uc_trigger').trigger('click');

        },200);

        return(true);
      }
      
      //if wrapper is inside another accordion tab
      setTimeout(function(){

        //if tab is active then skip and go to another one
        var isActive = objHashedTab.hasClass(g_activeClass);
        
        if(isActive == true)
        return(true);

        objHashedTab.find(' > .uc_trigger').trigger('click');
       
        //open parent accordion tab if it wasn't open already
        var isParentTabActive = objWrapperParent.hasClass(g_activeClass);

        if(isParentTabActive == true)
        return(true);

        objWrapperParent.find(' > .uc_trigger').trigger('click');
   
      },300);

      
    });
    
  }
  
  runPostAccordion();
  
}