(function($){
  function setMsg($wrap, text, type){
    var $msg = $wrap.find('.avasms-msg');
    $msg.removeClass('is-success is-error is-loading');
    if(type) $msg.addClass('is-'+type);
    $msg.text(text || '');
  }

  function getConfig($root){
    try { return JSON.parse($root.attr('data-avasms') || '{}'); } catch(e){ return {}; }
  }

  function ajax(config, data){
    return $.ajax({
      url: config.ajax_url,
      method: 'POST',
      dataType: 'json',
      data: data
    });
  }

  function showOtp($form){
    $form.find('.avasms-otp').show();
  }

  function bind($root){
    var config = getConfig($root);
    if(!config || !config.ajax_url) return;

    // -------- Turnstile (optional)
    function renderTurnstileIfNeeded(){
      if(!config.turnstile || !config.turnstile.enabled) return;
      if(!window.turnstile || typeof window.turnstile.render !== 'function'){
        // script loads async
        setTimeout(renderTurnstileIfNeeded, 300);
        return;
      }

      $root.find('.avasms-turnstile').each(function(){
        var el = this;
        if(el.__avasmsRendered) return;
        el.__avasmsRendered = true;
        var $form = $(el).closest('form');
        var $token = $form.find('[name="turnstile_token"]');
        try{
          window.turnstile.render(el, {
            sitekey: (config.turnstile.site_key || '').toString(),
            callback: function(token){
              if($token.length){ $token.val(token); }
            },
            'expired-callback': function(){
              if($token.length){ $token.val(''); }
            },
            'error-callback': function(){
              if($token.length){ $token.val(''); }
            }
          });
        }catch(e){
          el.__avasmsRendered = false;
        }
      });
    }

    renderTurnstileIfNeeded();

    // tabs
    $root.on('click', '.avasms-tab', function(){
      var tab = $(this).data('tab');
      $root.find('.avasms-tab').removeClass('is-active');
      $(this).addClass('is-active');
      $root.find('.avasms-pane').removeClass('is-active');
      $root.find('.avasms-pane[data-pane="'+tab+'"]').addClass('is-active');
    });

    $root.on('click', '[data-action="send"]', function(){
      var $form = $(this).closest('form');
      if($form && $form.attr('data-editor-preview') === '1'){
        setMsg($root, 'پیش‌نمایش المنتور: ارسال واقعی غیرفعال است.', 'error');
        return;
      }
      var ctx = $form.data('context') || 'login';
      var mobile = ($form.find('[name="mobile"]').val() || '').toString();
      var identifier = ($form.find('[name="identifier"]').val() || '').toString();
      var loginMethod = ($form.find('[name="login_method"]').val() || 'mobile').toString();
      var turnstileToken = ($form.find('[name="turnstile_token"]').val() || '').toString();

      setMsg($root, 'در حال ارسال کد...', 'loading');

      ajax(config, {
        action: 'avasms_send_otp',
        nonce: config.nonce,
        context: ctx,
        mobile: mobile,
        identifier: identifier,
        login_method: loginMethod,
        turnstile_token: turnstileToken,
        template: config.template
      }).done(function(res){
        if(res && res.success){
          showOtp($form);
          setMsg($root, res.data && res.data.message ? res.data.message : 'کد ارسال شد.', 'success');
        }else{
          setMsg($root, (res && res.data && res.data.message) ? res.data.message : 'ارسال ناموفق بود.', 'error');
        }
      }).fail(function(xhr){
        var msg = 'ارسال ناموفق بود.';
        if(xhr && xhr.responseJSON && xhr.responseJSON.data && xhr.responseJSON.data.message){
          msg = xhr.responseJSON.data.message;
        }
        setMsg($root, msg, 'error');
      });
    });

    $root.on('click', '[data-action="resend"]', function(){
      $(this).closest('form').find('[data-action="send"]').trigger('click');
    });

    $root.on('click', '[data-action="verify"]', function(){
      var $form = $(this).closest('form');
      if($form && $form.attr('data-editor-preview') === '1'){
        setMsg($root, 'پیش‌نمایش المنتور: ارسال واقعی غیرفعال است.', 'error');
        return;
      }
      var ctx = $form.data('context') || 'login';
      var mobile = ($form.find('[name="mobile"]').val() || '').toString();
      var identifier = ($form.find('[name="identifier"]').val() || '').toString();
      var loginMethod = ($form.find('[name="login_method"]').val() || 'mobile').toString();
      var code = ($form.find('[name="code"]').val() || '').toString();
      var turnstileToken = ($form.find('[name="turnstile_token"]').val() || '').toString();

      var data = {
        action: 'avasms_verify_otp',
        nonce: config.nonce,
        context: ctx,
        mobile: mobile,
        identifier: identifier,
        login_method: loginMethod,
        code: code,
        turnstile_token: turnstileToken,
        redirect: config.redirect
      };

      // optional register fields
      if(ctx === 'register'){
        data.first_name = ($form.find('[name="first_name"]').val() || '').toString();
        data.last_name  = ($form.find('[name="last_name"]').val() || '').toString();
        data.email      = ($form.find('[name="email"]').val() || '').toString();
        data.birthdate  = ($form.find('[name="birthdate"]').val() || '').toString();
        data.marketing_optin = $form.find('[name="marketing_optin"]').is(':checked') ? '1' : '0';
      }

      setMsg($root, 'در حال تایید...', 'loading');

      ajax(config, data).done(function(res){
        if(res && res.success){
          setMsg($root, res.data && res.data.message ? res.data.message : 'موفق.', 'success');
          var r = (res.data && res.data.redirect) ? res.data.redirect : config.redirect;
          if(r) window.location.href = r;
        }else{
          setMsg($root, (res && res.data && res.data.message) ? res.data.message : 'کد اشتباه است.', 'error');
        }
      }).fail(function(xhr){
        var msg = 'تایید ناموفق بود.';
        if(xhr && xhr.responseJSON && xhr.responseJSON.data && xhr.responseJSON.data.message){
          msg = xhr.responseJSON.data.message;
        }
        setMsg($root, msg, 'error');
      });
    });
  }

  $(window).on('elementor/frontend/init', function(){
    // Elementor frontend init
    if(window.elementorFrontend && elementorFrontend.hooks){
      elementorFrontend.hooks.addAction('frontend/element_ready/ava_sms_login_register.default', function($scope){
        bind($scope.find('.avasms-auth').first());
      });
    }
  });

  $(function(){
    // Non-elementor fallback (shortcodes etc)
    $('.avasms-auth').each(function(){ bind($(this)); });
  });
})(jQuery);
