<?php
namespace Avayemarketing\AvaSMS;

use Avayemarketing\AvaSMS\Admin\AdminModule;
use Avayemarketing\AvaSMS\Logging\Logger;
use Avayemarketing\AvaSMS\Campaigns\CampaignsModule;
use Avayemarketing\AvaSMS\WooCommerce\AccountFields;
use Avayemarketing\AvaSMS\SMS\SmsModule;
use Avayemarketing\AvaSMS\Auth\AuthModule;
use Avayemarketing\AvaSMS\User\BirthdateField;
use Avayemarketing\AvaSMS\Elementor\ElementorModule;

if (!defined('ABSPATH')) exit;

final class Plugin
{
    /** @var self|null */
    private static $instance = null;

    public static function instance(): self
    {
        if (self::$instance === null) self::$instance = new self();
        return self::$instance;
    }

    public function boot(): void
    {
        load_plugin_textdomain('avasms', false, dirname(plugin_basename(AVASMS_FILE)) . '/languages');

        // Cron schedule: every minute (for campaigns queue)
        add_filter('cron_schedules', function (array $schedules): array {
            if (!isset($schedules['minute'])) {
                $schedules['minute'] = [
                    'interval' => 60,
                    'display'  => 'Every Minute',
                ];
            }
            return $schedules;
        });

        if (is_admin()) {
            (new AdminModule())->register_hooks();
        }

        (new SmsModule())->register_hooks();
        (new CampaignsModule())->register_hooks();
        (new Logger())->register_hooks();

        // Woo optional
        (new AccountFields())->register_hooks();

        // User meta fields (WP profile + WP register)
        (new BirthdateField())->register_hooks();

        // Frontend OTP auth endpoints (used by Elementor widget)
        (new AuthModule())->register_hooks();

        // Elementor widget registration
        (new ElementorModule())->register_hooks();
    }

    public function activate(): void
    {
        (new Logger())->install();
        (new CampaignsModule())->install_tables();

        // Cleanup legacy/invalid cron schedule from previous versions
        if (function_exists('wp_clear_scheduled_hook')) {
            wp_clear_scheduled_hook('avasms_campaign_send_queue');
        }
    }

    public function deactivate(): void
    {
        // Keep data; only clear legacy hooks
        if (function_exists('wp_clear_scheduled_hook')) {
            wp_clear_scheduled_hook('avasms_campaign_send_queue');
        }
    }
}