<?php
namespace Avayemarketing\AvaSMS\SMS\Gateways;

use Avayemarketing\AvaSMS\SMS\GatewayInterface;

if (!defined('ABSPATH')) exit;

abstract class AbstractGateway implements GatewayInterface
{
    /** @var array<string,mixed> */
    protected array $settings = [];

    public function __construct(array $settings = [])
    {
        $this->settings = is_array($settings) ? $settings : [];
    }

    protected function http_post(string $url, array $body, array $headers = []): array
    {
        $args = [
            'timeout' => 15,
            'headers' => $headers,
            'body'    => $body,
        ];

        $resp = wp_remote_post($url, $args);
        if (is_wp_error($resp)) {
            return [
                'ok' => false,
                'code' => 'wp_error',
                'raw' => $resp->get_error_message(),
            ];
        }

        $code = (int)wp_remote_retrieve_response_code($resp);
        $raw_body = wp_remote_retrieve_body($resp);

        return [
            'ok' => ($code >= 200 && $code < 300),
            'code' => (string)$code,
            'raw' => $raw_body,
        ];
    }
}
