<?php
namespace Avayemarketing\AvaSMS\WooCommerce;

use Avayemarketing\AvaSMS\Logging\Logger;

if (!defined('ABSPATH')) exit;

final class AccountFields
{
    public function register_hooks(): void
    {
        if (!class_exists('WooCommerce')) return;

        add_action('woocommerce_edit_account_form', [$this, 'render_fields']);
        add_action('woocommerce_save_account_details', [$this, 'save_fields'], 10, 1);
    }

    public function render_fields(): void
    {
        $user_id = get_current_user_id();
        if ($user_id <= 0) return;

        $birthday = (string) get_user_meta($user_id, 'avasms_birthdate', true);
        $optin = (int) get_user_meta($user_id, 'avasms_marketing_optin', true);

        echo '<fieldset style="margin-top:18px;">';
        echo '<legend>اطلاعات تکمیلی</legend>';

        echo '<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">';
        echo '<label for="avasms_birthdate">تاریخ تولد</label>';
        echo '<input type="date" class="woocommerce-Input woocommerce-Input--text input-text" name="avasms_birthdate" id="avasms_birthdate" value="' . esc_attr($birthday) . '">';
        echo '</p>';

        echo '<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">';
        echo '<label style="display:flex; gap:8px; align-items:center;">';
        echo '<input type="checkbox" name="avasms_marketing_optin" value="1" ' . checked(1, $optin, false) . '>';
        echo 'مایلم پیامک‌های اطلاع‌رسانی/تبلیغاتی دریافت کنم';
        echo '</label>';
        echo '</p>';

        echo '</fieldset>';
    }

    public function save_fields(int $user_id): void
    {
        if ($user_id <= 0) return;

        if (isset($_POST['avasms_birthdate'])) {
            $bd = sanitize_text_field(wp_unslash($_POST['avasms_birthdate']));
            if ($bd === '' || preg_match('/^\d{4}-\d{2}-\d{2}$/', $bd)) {
                update_user_meta($user_id, 'avasms_birthdate', $bd);
            }
        }

        $optin = !empty($_POST['avasms_marketing_optin']) ? 1 : 0;
        update_user_meta($user_id, 'avasms_marketing_optin', $optin);

        Logger::log('info', 'account', 'اطلاعات تکمیلی بروزرسانی شد.', ['user_id'=>$user_id,'optin'=>$optin]);
    }
}
