<?php
defined('ABSPATH') || exit;
get_header();
?>
<main id="primary" class="site-main container">
    <header class="page-header">
        <h1 class="page-title">
            <?php printf( esc_html__('Search Results for: %s', 'businesspro'), '<span>' . esc_html(get_search_query()) . '</span>' ); ?>
        </h1>
    </header>

    <?php if ( have_posts() ) : ?>
        <?php while ( have_posts() ) : the_post(); ?>
            <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                <header class="entry-header">
                    <h2 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                </header>
                <div class="entry-content">
                    <?php the_excerpt(); ?>
                </div>
            </article>
        <?php endwhile; ?>

        <nav class="navigation pagination">
            <?php the_posts_pagination(); ?>
        </nav>
    <?php else : ?>
        <p><?php esc_html_e('No results found.', 'businesspro'); ?></p>
    <?php endif; ?>
</main>
<?php get_footer(); ?>
